<?php
/**
 * Plugin Name: Heslář Open Science - tooltipy
 * Plugin URI: https://openscience.cz
 * Description: Integrace Hesláře pro jakýkoli WP web
 * Version: 1.0.0
 * Author: Martin Pavlíček (martin.pavlicek@techlib.cz)
 * Text Domain: heslar-tooltips
 * Domain Path: /languages
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class HeslarTooltips {
    private $api_url = 'https://testheslare.mojentk.cz/api/v1/heslar/';
    private $cache_duration = 3600; // 1 hour
    
    public function __construct() {
        add_action('init', array($this, 'init'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
        add_shortcode('heslar', array($this, 'tooltip_shortcode'));
        add_shortcode('heskar', array($this, 'tooltip_shortcode'));
        add_shortcode('heslo', array($this, 'tooltip_shortcode'));
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    public function init() {
        // Plugin initialization
        load_plugin_textdomain('heslar-tooltips', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }
    
    public function activate() {
        // Clear any existing cache on activation
        delete_transient('heslar_data_cache');
    }
    
    public function deactivate() {
        // Clean up cache on deactivation
        delete_transient('heslar_data_cache');
    }
    
    private function fetch_heslar_data() {
        $cache_key = 'heslar_data_cache';
        $data = get_transient($cache_key);
        
        if (!$data) {
            $response = wp_remote_get($this->api_url, array(
                'timeout' => 15,
                'headers' => array(
                    'Accept' => 'application/json'
                )
            ));
            
            if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                $body = wp_remote_retrieve_body($response);
                $json_data = json_decode($body, true);
                
                if ($json_data && isset($json_data['data']) && is_array($json_data['data'])) {
                    // Index by ID for faster lookup
                    $data = array();
                    foreach ($json_data['data'] as $item) {
                        if (isset($item['id'])) {
                            $data[$item['id']] = $item;
                        }
                    }
                    set_transient($cache_key, $data, $this->cache_duration);
                }
            }
        }
        
        return $data ?: array();
    }
   
    public function sestav_heslo(array $radek): string
    {

	    $out = '<h3>Heslo</h3>';
            $out .=  "<strong>".$radek['termin_cs']."</strong>";
            if($radek['zkratka_cs']!=null)
            {
                $out .= " (".$radek['zkratka_cs'].")";
            }
            $out .=  " = ";
            $out .=  $radek['termin_en'];
            if($radek['zkratka_en']!=null)
            {
                $out .=  " (".$radek['zkratka_en'].")";
            }
            $out .=  ": ";
	    $out .=  $radek['popis_cs'];
        # doplneni
	    # $out .= '<h3>Zdroje</h3>';
	    # $out .= '<h3>Autor</h3>';
	    # $out .= '<h3>Odkaz do hesláře</h3>';

	    return $out;
            #$out .=  $this->prepis_url_www_public($radek['h_popis']);
            #$out .=  "<p><strong>Zdroj</strong>: ".$this->odkazy_zdroje_public(zdroje_text:$radek['zdroj'])."</p>";
            #$out .=  "<p><strong>Autor hesla</strong>: ".$this->cely_autor_public($radek['vlastnik'])."</p>";


    }

    public function tooltip_shortcode($atts, $content = null) {
        $atts = shortcode_atts(array(
            'id' => '',
            'term' => '' // Optional: find by term instead of ID
        ), $atts);
        
        // Get content between shortcode tags (the text to wrap)
        $display_text = !empty($content) ? $content : '';
        
        if (empty($atts['id']) && empty($atts['term'])) {
            return $display_text;
        }
        
        $heslar_data = $this->fetch_heslar_data();
        $tooltip_content = '';
        
	if (!empty($atts['id']) && isset($heslar_data[$atts['id']])) 
	{
		$item = $heslar_data[$atts['id']];
		$heslo = $this->sestav_heslo($item);
            	# $tooltip_content = wp_strip_all_tags($item['popis_cs'])."AUTOR: ".$item['autor'];
            	#$tooltip_content = wp_strip_all_tags($heslo);
            	$tooltip_content = $heslo;

        } elseif (!empty($atts['term'])) {
            // Search by term
            foreach ($heslar_data as $item) {
                if (isset($item['termin_cs']) && strcasecmp($item['termin_cs'], $atts['term']) === 0) {
                    $tooltip_content = wp_strip_all_tags($item['popis_cs']);
                    break;
                }
            }
        }
        
        // If no tooltip content found or no text to wrap, return original content
        if (empty($tooltip_content) || empty($display_text)) {
            return $display_text;
        }
        
        return sprintf(
            '<span class="heslar-tooltip" data-tooltip="%s" tabindex="0">%s</span>',
            esc_attr($tooltip_content),
            do_shortcode($display_text) // Process any nested shortcodes
        );
    }
    
    public function enqueue_scripts() {
        wp_enqueue_style(
            'heslar-tooltips-css', 
            plugin_dir_url(__FILE__) . 'heslar-tooltips.css',
            array(),
            '1.0.0'
        );
        
        wp_enqueue_script(
            'heslar-tooltips-js', 
            plugin_dir_url(__FILE__) . 'heslar-tooltips.js', 
            array('jquery'),
            '1.0.0',
            true
        );
    }
}

// Initialize the plugin
new HeslarTooltips();
